#ifdef __TURBOC__
  #if (__TURBOC__ < 0x0300)
/*    #define inp    inportb */
    #define inpw   inport
/*    #define outp   outportb */
    #define outpw  outport
  #endif
#endif

#define BUF_SIZE     1024   /* must be 2 ** n */
#define IN_BUF_SIZE  1024
#define OUT_BUF_SIZE  512

#define    NoError	    0
#define    InitPinIsOpen    0
#define    InitPinIsNotopen 1
#define    QueueIsEmpty     0
#define    QueueIsNotEmpty  1
#define    PortError	   -1
#define    DataError	   -2
#define    ParityError	   -3
#define    StopError	   -4
#define    TimeOut	   -5
#define    QueueEmpty	   -6
#define    QueueOverflow   -7
#define    PosError	   -8
#define    AddrError	   -9
#define    BlockError	   -10
#define    WriteError	   -11
#define    SegmentError    -12
#define    BaudRateError   -13
#define    CheckSumError   -14
#define    ChannelError    -15
#define    BaudrateError   -16
#define    TriggerLevelError   -17
#define    DateError    -18
#define    TimeError    -19
#define    TimeIsUp        1

extern char hex_to_ascii[16];

#ifdef __cplusplus
extern "C" {
#endif

void InitLib(void);
int  InstallCom(int port, unsigned long baud, int data, int parity,int stop);
int  InstallCom0(unsigned long baud, int data, int parity);
int  InstallCom1(unsigned long baud, int data, int parity);
int  InstallCom2(unsigned long baud, int data, int parity,int stop);
int  InstallCom3(unsigned long baud, int data, int parity,int stop);
int  InstallCom4(unsigned long baud, int data, int parity,int stop);
int  RestoreCom(int port);
int  RestoreCom0(void);
int  RestoreCom1(void);
int  RestoreCom2(void);
int  RestoreCom3(void);
int  RestoreCom4(void);
int  IsCom(int port);
int  IsCom0(void);
int  IsCom1(void);
int  IsCom2(void);
int  IsCom3(void);
int  IsCom4(void);
int  ReadCom(int port);
int  ReadCom0(void);
int  ReadCom1(void);
int  ReadCom2(void);
int  ReadCom3(void);
int  ReadCom4(void);
int  ToCom(int port, int data);
int  ToCom0(int data);
int  ToCom1(int data);
int  ToCom2(int data);
int  ToCom3(int data);
int  ToCom4(int data);
int ToComBufn(int port,char *buf,int no);
int ToCom0Bufn(char *buf,int no);
int ToCom1Bufn(char *buf,int no);
int ToCom2Bufn(char *buf,int no);
int ToCom3Bufn(char *buf,int no);
int ToCom4Bufn(char *buf,int no);
int  ToComStr(int port, char *str);
int  ToCom0Str(char *str);
int  ToCom1Str(char *str);
int  ToCom2Str(char *str);
int  ToCom3Str(char *str);
int  ToCom4Str(char *str);
int  ClearCom(int port);
int  ClearCom0(void);
int  ClearCom1(void);
int  ClearCom2(void);
int  ClearCom3(void);
int  ClearCom4(void);
int  WaitTransmitOver(int port);
int  WaitTransmitOver0(void);
int  WaitTransmitOver1(void);
int  WaitTransmitOver2(void);
int  WaitTransmitOver3(void);
int  WaitTransmitOver4(void);

int  ReadInitPin(void);
void Init5DigitLed(void);
int  Show5DigitLed(int position, int value);
int  Show5DigitLedSeg(int pos, unsigned char data);
void DelayTimeMs(unsigned int time);

int  WriteEEP(int block, int addr, int data);
int  ReadEEP(int block, int addr);
void EnableEEP(void);
void ProtectEEP(void);

void EnableWDT(void);
void RefreshWDT(void);
void DisableWDT(void);

int FlashReadId(void);
int FlashWrite(unsigned int seg, unsigned int offset, char data);
int FlashErase(unsigned int seg);
int FlashRead(unsigned int seg, unsigned int offset);

void Delay(unsigned ms);
void Delay_1(unsigned ms);

int Is8000(void);
int Getch(void);
int Kbhit(void);
int Ungetch(int key);
void Putch(int data);
int Puts(char *str);
int Print(char *fmt,...);

int ascii_to_hex(char ascii);
int SendCmdTo7000(int iPort, unsigned char *cCmd, int iChksum);
int ReceiveResponseFrom7000(int iPort, unsigned char *cCmd, long lTimeout, int iChksum);

void far *_MK_FP(unsigned segment,unsigned offset);
int IsResetByWatchDogTimer(void);
int IsResetByPowerOff(void); /* for bios date 12/12/98 or later */

int Show5DigitLedWithDot(int pos, int data);
void Set5DigitLedTestMode(int mode);
void Set5DigitLedIntensity(int mode);
void Disable5DigitLed(void);
void Enable5DigitLed(void);
unsigned GetLibVersion(void);

/* 01/07/1999  Add Timer function */
int TimerOpen(void);
int TimerClose(void);
void TimerResetValue(void);
unsigned long TimerReadValue(void);
void DelayMs(unsigned t);
int StopWatchReset(int channel);
int StopWatchStart(int channel);
int StopWatchStop(int channel);
int StopWatchPause(int channel);
int StopWatchContinue(int channel);
int StopWatchReadValue(int channel,unsigned long *value);
int CountDownTimerStart(int channel,unsigned long count);
int CountDownTimerReadValue(int channel,unsigned long *value);
void InstallUserTimer(void (*fun)(void));
void InstallUserTimer1C(void (*fun)(void));
int DataSizeInCom(int port);
int DataSizeInCom0(void);
int DataSizeInCom1(void);
int DataSizeInCom2(void);
int DataSizeInCom3(void);
int DataSizeInCom4(void);

int SetCom2FifoTriggerLevel(int level);

/* New for Ver 1.13 */
/* 07-23-1999 add 4 function for COM1 /DTR,/RTS output pins */
void SetRtsActive(void);
void SetRtsInactive(void);

/* [New for Ver 1.14] */
/**** 07/27/1999 add 5 function for COM1/2/3/4 formated output ****/
int printCom(int port,char *fmt,...);
int printCom0(char *fmt,...);
int printCom1(char *fmt,...);
int printCom2(char *fmt,...);
int printCom3(char *fmt,...);
int printCom4(char *fmt,...);
/* 08/06/1999 add 2 function for COM1 CTS,DSR input pins */
int GetCtsStatus(void);

/* 08/25/1999 add 5 function for COM1-4 */
int IsTxBufEmpty(int port);
int IsTxBufEmpty0(void);
int IsTxBufEmpty1(void);
int IsTxBufEmpty2(void);
int IsTxBufEmpty3(void);
int IsTxBufEmpty4(void);

/* 10/19/1999 add 5 function for COM1/2/3/4 change baudrate */
int SetBaudrate(int port,unsigned long baud);
int SetBaudrate0(unsigned long baud);
int SetBaudrate1(unsigned long baud);
int SetBaudrate2(unsigned long baud);
int SetBaudrate3(unsigned long baud);
int SetBaudrate4(unsigned long baud);

/* 10/20/1999 */
/* (1) add 10 function for COM1/2/3/4 send/detect BREAK signal */
int SendBreak(int port,unsigned timems);
void SendBreak0(unsigned timems);
void SendBreak1(unsigned timems);
void SendBreak2(unsigned timems);
int IsDetectBreak(int port);
int IsDetectBreak0(void);
int IsDetectBreak1(void);
int IsDetectBreak2(void);
int IsDetectBreak3(void);
int IsDetectBreak4(void);

/* (2) Add 3 functions for clear COM1/2/3/4 output buffer */
int ClearTxBuffer(int port);
void ClearTxBuffer0(void);
void ClearTxBuffer1(void);
void ClearTxBuffer2(void);
void ClearTxBuffer3(void);
void ClearTxBuffer4(void);

#ifndef __FILE_DATA__
#define __FILE_DATA__
typedef struct  {
  unsigned mark;   /* 0x7188 -> is file */
  unsigned char fname[12];
  unsigned char year;
  unsigned char month;
  unsigned char day;
  unsigned char hour;
  unsigned char minute;
  unsigned char sec;
  unsigned long size;
  char far *addr;
  unsigned CRC;
  unsigned CRC32;
} FILE_DATA;
#endif

/* 12/29/1999 */
/*
  Add functions for ReadOnly file system of 7188R/7188X
*/
int GetFileNo(void);
int GetFileName(int no,char *fname);
char far *GetFilePositionByNo(int no);
char far *GetFilePositionByName(char *fname);

/*
 02/17/2000
 Add functions for LED RUN/BATT/COMM
 12/06/2000 Rename these function with the final name L1/L2/L3
*/
/*
void LedBattOn(void);
void LedBattOff(void);
void LedCommOn(void);
void LedCommOff(void);
void LedRunOn(void);
void LedRunOff(void);
*/
#define LED_OFF     0
#define LED_ON      1
#define LED_TOGGLE  2

#define LedBattOn()   SetLedL3(LED_ON)
#define LedBattOff()  SetLedL3(LED_OFF)
#define LedCommOn()   SetLedL2(LED_ON)
#define LedCommOff()  SetLedL2(LED_OFF)
#define LedRunOn()    SetLedL1(LED_ON)
#define LedRunOff()   SetLedL1(LED_OFF)


/*
 02/21/2000
 Add functions for SystemKey (UP,DOWN,MODE,SET)
*/
#define SKEY_SET    1
#define SKEY_MODE   2
#define SKEY_UP     3
#define SKEY_DOWN   4

int IsSystemKey(void);
int GetSystemKey(void);
void ClearSystemKey(void);

/*
 03/15/2000
 Add function Scanf ...
*/
int LineInput(char *buf,int maxlen); /* input one line from StdInput */
void ResetScanBuffer(void); /* Set Scanf to use default buffer(maxlen=80) */
void SetScanBuffer(unsigned char *buf,int len); /* Set user's buffer for Scanf */
int Scanf(char *fmt, ...); /* like C's scanf */

/*
06/01/2000
 Add functions for RTC/NVRAM
*/
void ReadRTC(int addr, int *data);
void WriteRTC(int addr, int data);
int ReadNVRAM(int addr);
int WriteNVRAM(int addr, int data);
void GetDate(int *year,int *month,int *day);
void GetTime(int *hour,int *minute,int *sec);
int SetDate(int year,int month,int day);
int SetTime(int hour,int minute,int sec);

/*
07/31/2000
  Add functions for Change Slot,and address bus A9,A12,B1A5,B1A6
*/
void ChangeToSlot(int slot);  /* slot=0,1,2,3,4,5,6,7 */
void SetA9(int mode);         /* mode: 0-> low , 1-> high */
void SetA12(int mode);        /* mode: 0-> low , 1-> high */
void SetB1A5(int mode);       /* mode: 0-> low , 1-> high */
void SetB1A6(int mode);       /* mode: 0-> low , 1-> high */
int GetNetId(void);           /* range 0-255 */

/*
08/01/2000
  Add functions for Set/Read weekday
*/
int GetWeekDay(void);     /* 0-6, 0:Sun., 1:Mon., ... 6:Sat.*/
void SetWeekDay(int day);

/*
11/03/2000
  Add function for 8000 series cards
*/
extern unsigned char far const *ModuleType;
extern unsigned char far const *NameOfModule;
void ShowLED16(int slot ,unsigned data); /* used for DO16 */
void ShowLED8(int slot ,unsigned char data); /* used for DI8DO8 's DO8 */
int GetNumberOfSlot(void); /* return 4 or 8 */


/*
12/04/2000
  Add function for 8000 , parallel DIO cards
*/
typedef union {
  struct {
   unsigned char di8,do8;
  } data8;
  unsigned      data16;
} DIODATA;
extern int SlotAddr[8];
extern DIODATA DIOData[8];

void DO_16(int slot,unsigned int cdata); /* For 16 bits output */
void DO_8(int slot,unsigned char cdata); /* For 8 bits output */
void DIO_DO_8(int slot,unsigned char cdata); /* For 8 bits output on DI8/DO8*/
unsigned int DI_16(int slot); /* For 16 bits input */
unsigned char DI_8(int slot); /* For 8 bits input */


/*
12/06/2000
  Add function for 8000, LED_L1,LED_L2,LED_L3

*/
void SetLedL1(int mode); /* mode can be LED_OFF, LED_ON ,LED_TOGGLE */
void SetLedL2(int mode);
void SetLedL3(int mode);

/*
12/07/2000
  Add function for 8000, slot 4-7 interrupt signal
*/
void ClrSlotInt(int slot);
int GetSlotInt(void);

/*
01/11/2001
  Add variable for system serial number.
*/
extern unsigned char far const *SystemSerialNumber;
#ifdef __cplusplus
 }
#endif
